SELECT sc.name AS TABLE_SCHEMA, o.name AS TABLE_NAME,
       s.name AS STAT_NAME, last_updated, rows, modification_counter,
       (1.0 * modification_counter / rows) * 100 AS PERCENT_MODIFIED
FROM   sys.stats AS s
       CROSS APPLY sys.dm_db_stats_properties(s.object_id, s.stats_id) AS p
       INNER JOIN sys.objects AS o
             ON s.object_id = o.object_id
       INNER JOIN sys.schemas AS sc
             ON o.schema_id = sc.schema_id
WHERE  o."type" IN ('U', 'V')
  AND  CASE WHEN modification_counter = 0
               THEN 0
            WHEN rows < 300 AND (1.0 * modification_counter / rows) * 100 > 1
               THEN 1
            WHEN rows > 100000 AND (1.0 * modification_counter / rows) * 100 > 16
               THEN 1
            WHEN (1.0 * modification_counter / rows) * 100 > (SQUARE(LOG((rows/1000.0) + 1) + 2) / 8)
               THEN 1
            ELSE 0
       END = 1;

--> NOTA : cette requte ne fonctionnqu' partir de la version 2008 R2 SP2. La fonction systme table sys.dm_db_stats_properties ayant t introduite  ce moment
--> NOTA : ne vous tonnez pas de chiffres suprieur  100 % dans la colonne PERCENT_MODIFIED. En effet une mme valeur peut avoir t mis  jour plusieurs fois.